SET SQL DIALECT 3;
SET NAMES NONE;
SET AUTODDL ON;

/******************************************************************************/
/****                              Generators                              ****/
/******************************************************************************/
CREATE GENERATOR GEN_XRCHECK_ID;


/******************************************************************************/
/****                          Stored Procedures                           ****/
/******************************************************************************/

SET TERM ^ ; 

CREATE PROCEDURE GET_XRCHECKID
RETURNS (
    ID INTEGER)
AS
BEGIN
  SUSPEND;
END^

SET TERM ; ^


/******************************************************************************/
/****                                Tables                                ****/
/******************************************************************************/

CREATE TABLE XRCHECKS (
    CHECKID          INTEGER,
    CHECKTYPE        SMALLINT,
    EMITTERID        INTEGER,
    EMITTERNAME      VARCHAR(60) CHARACTER SET UTF8,
    KILOVOLT         DOUBLE PRECISION,
    MILLIAMP         DOUBLE PRECISION,
    ROEDAUER         DOUBLE PRECISION,
    DEVALUE          DOUBLE PRECISION,
    DECALCTYPE       SMALLINT,
    DEAREACOORDTYPE  SMALLINT,
    DEAREALEFT       DOUBLE PRECISION,
    DEAREATOP        DOUBLE PRECISION,
    DEAREARIGHT      DOUBLE PRECISION,
    DEAREABOTTOM     DOUBLE PRECISION,
    CREATIONDATE     TIMESTAMP,
    CREATIONUSER     VARCHAR(60) CHARACTER SET UTF8,
    INPSYSTPRIMID    VARCHAR(60),
    INPSYSTSECID     VARCHAR(60),
    INPSYSTNAME      VARCHAR(60) CHARACTER SET UTF8,
    IMGFILE1         VARCHAR(36),
    IMGFILE2         VARCHAR(36),
    IMGFILE3         VARCHAR(36),
    IMGFILE4         VARCHAR(36),
    RESULTREPORT     BLOB SUB_TYPE 0 SEGMENT SIZE 1024,
    MEMO1            BLOB SUB_TYPE 0 SEGMENT SIZE 256
);

CREATE TABLE VERSIONSTATE(
  VID         INTEGER NOT NULL,
  VERSNR      DOUBLE PRECISION,
  LASTCHANGE  TIMESTAMP);


/******************************************************************************/
/****                             Primary Keys                             ****/
/******************************************************************************/

ALTER TABLE VERSIONSTATE ADD CONSTRAINT PK_VERSIONSTATE PRIMARY KEY (VID);


/******************************************************************************/
/****                               Indices                                ****/
/******************************************************************************/

CREATE INDEX CTYPEINDX ON XRCHECKS (CHECKTYPE);
CREATE INDEX EMITNAMEINDX ON XRCHECKS (EMITTERNAME);
CREATE INDEX INPSYSTNAMEINDX ON XRCHECKS (INPSYSTNAME);
CREATE INDEX ORDERBYDATE ON XRCHECKS (CREATIONDATE);
CREATE INDEX SEARCHINDX ON XRCHECKS (EMITTERID);


/******************************************************************************/
/****                          Stored Procedures                           ****/
/******************************************************************************/

SET TERM ^ ;

ALTER PROCEDURE GET_XRCHECKID
RETURNS (
    ID INTEGER)
AS
begin
  id = GEN_ID(GEN_XRCHECK_ID, 1);
end
^

SET TERM ; ^
