SET SQL DIALECT 3;
SET NAMES NONE;
SET AUTODDL ON;

-- Drop Columns
ALTER TABLE DCMIMG DROP PNR;
ALTER TABLE DCMIMG DROP ACCESSIONNUMBER;
ALTER TABLE DCMIMG DROP STUDYDATE;
ALTER TABLE DCMIMG DROP STUDYTIME;
ALTER TABLE DCMIMG DROP REFERRINGPHYSICIAN;
ALTER TABLE DCMIMG DROP STUDYID;
ALTER TABLE DCMIMG DROP STUDYDESCRIPTION;
ALTER TABLE DCMIMG DROP REFERSOPCLASSUID;
ALTER TABLE DCMIMG DROP REFERSOPINSTANCEUID;

-- Add NOT NULL Constraints
UPDATE RDB$RELATION_FIELDS SET RDB$NULL_FLAG = 1 WHERE RDB$FIELD_NAME = 'INSTANCENUMBER' AND RDB$RELATION_NAME = 'DCMIMG';
UPDATE RDB$RELATION_FIELDS SET RDB$NULL_FLAG = 1 WHERE RDB$FIELD_NAME = 'PNR' AND RDB$RELATION_NAME = 'GRUPPE';

COMMIT;

-- Add Constraints
ALTER TABLE PRESENTATIONSTATE ADD CONSTRAINT FK_PRESENTATIONSTATE_GRUPPE FOREIGN KEY (GID) REFERENCES GRUPPE (GID) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE PRESENTATIONSTATE ADD CONSTRAINT FK_PRESENTATIONSTATE_XRAYVIDEO FOREIGN KEY (VORGNR, ITYP) REFERENCES XRAYVIDEO (VORGNR, ITYP) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE DCMIMG ADD CONSTRAINT PK_DCMIMG PRIMARY KEY (VORGNR,IMAGEKIND);
ALTER TABLE DCMIMG ADD CONSTRAINT FK_DCMIMG_STUDY FOREIGN KEY (STUDYINSTANCEUID) REFERENCES STUDY (UID) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE DCMIMG ADD CONSTRAINT FK_DCMIMG_XRAYVIDEO FOREIGN KEY (VORGNR, IMAGEKIND) REFERENCES XRAYVIDEO (VORGNR, ITYP) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE GRUPPE ADD CONSTRAINT FK_GRUPPE_PATIENT FOREIGN KEY (PNR) REFERENCES PATIENT (PNR) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE GRUPPE ADD CONSTRAINT FK_GRUPPE_STUDY FOREIGN KEY (STUDYINSTANCEUID) REFERENCES STUDY (UID) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE STUDY ADD CONSTRAINT FK_STUDY_PNR FOREIGN KEY (PNR) REFERENCES PATIENT (PNR) ON UPDATE CASCADE ON DELETE CASCADE;

-- Drop Tables
DROP TABLE XRAY;
DROP TABLE VIDEO;
DROP TABLE ARCHIVED;
DROP TABLE ARCHTEMP;
DROP TABLE ARCINDEX;


COMMIT;
