-- Skript Practice305Update.sql aktualisiert mehrere Sekundrindizies der Tabelle PATIENT der Praxis-DB: von Version 3.04 auf 3.05.

SET SQL DIALECT 3;
SET NAMES NONE;
SET AUTODDL ON;

-- ConditiIndizes lschen, falls vorhanden
SET TERM ^ ; 



/******************************************************************************/
/****                          Stored Procedures                           ****/
/******************************************************************************/
/******************************************************************************/
/****                          DELETE_INDEX                                ****/
/**** Conditional delete of an index only if existing                         */
/**** Usecase : Some customers have manually generated indexes, that would    */
/***  cause a fail of database update ( which would try to create the same    */
/**   indices again) Issue 4704                                               */
/******************************************************************************/
CREATE PROCEDURE DELETE_INDEX (
    INDEXNAME VARCHAR(80))
AS
declare s1 varchar (120) ;
begin
  IF (exists(select 1 from rdb$indices where RDB$INDEX_NAME = :Indexname)) THEN BEGIN
    S1 = 'DROP INDEX ' || :Indexname || ' ;';
    execute statement S1 ;
  end
end^

SET TERM ; ^
COMMIT;

EXECUTE PROCEDURE DELETE_INDEX 
  'IDX_PATIENT_COLLATE_ASC';
EXECUTE PROCEDURE DELETE_INDEX 
  'IDX_PATIENT_COLLATE_DESC';
EXECUTE PROCEDURE DELETE_INDEX 
  'IDX_PATIENT_KNR_COLLATE_ASC';
EXECUTE PROCEDURE DELETE_INDEX 
  'IDX_PATIENT_KNR_COLLATE_DESC';
EXECUTE PROCEDURE DELETE_INDEX
  'IDX_PATIENT_PVNAME_COLLATE_ASC';
EXECUTE PROCEDURE DELETE_INDEX 
  'IDX_PATIENT_PVNAME_COLLATE_DESC';

COMMIT;

CREATE INDEX IDX_PATIENT_COLLATE_ASC ON PATIENT COMPUTED BY (UPPER(PNNAME COLLATE UNICODE_CI_AI));
CREATE DESCENDING INDEX IDX_PATIENT_COLLATE_DESC ON PATIENT COMPUTED BY (UPPER(PNNAME COLLATE UNICODE_CI_AI));
CREATE INDEX IDX_PATIENT_KNR_COLLATE_ASC ON PATIENT COMPUTED BY (UPPER(KNR COLLATE UNICODE_CI_AI));
CREATE DESCENDING INDEX IDX_PATIENT_KNR_COLLATE_DESC ON PATIENT COMPUTED BY (UPPER(KNR COLLATE UNICODE_CI_AI));
CREATE INDEX IDX_PATIENT_PVNAME_COLLATE_ASC ON PATIENT COMPUTED BY (UPPER(PVNAME COLLATE UNICODE_CI_AI));
CREATE DESCENDING INDEX IDX_PATIENT_PVNAME_COLLATE_DESC ON PATIENT COMPUTED BY (UPPER(PVNAME COLLATE UNICODE_CI_AI));

COMMIT;