-- Skript Practice301Update.sql aktualisiert das Schema der Praxis-DB von Version 3.00 auf 3.01.

SET SQL DIALECT 3;
SET NAMES NONE;
SET AUTODDL ON;

-- Neues Feld mit kurzer, eindeutiger ID, die bentigt wird, damit die DLL-Schnittstelle
-- abwrtskompatibel bleiben kann. 
-- Ein NOT NULL Constraint wird verzgert in Skript Practice301Finalize.sql erzeugt. 
-- Vorher mssen jedoch erst eindeutige IDs via Delphi Code generiert werden.
ALTER TABLE XRAYVIDEO ADD EXPORTID VARCHAR(12) CHARACTER SET UTF8;
UPDATE RDB$RELATION_FIELDS SET RDB$NULL_FLAG = 1 WHERE RDB$FIELD_NAME = 'EXPORTID' AND RDB$RELATION_NAME = 'XRAYVIDEO';
COMMIT;
CREATE UNIQUE INDEX IDX_XRAYVIDEO_EXPORTID ON XRAYVIDEO (EXPORTID);

-- Tabelle IMPORTPAT wurde nie benutzt.
DROP TRIGGER IMPORTPAT_BI0;
DROP TABLE IMPORTPAT;

-- Neues Feld PREVIEWINVALID zeigt an, ob das Thumbnail einer Ansicht nach dem nchsten Laden 
-- aktualisiert werden muss ('1') oder nicht ('0').
-- Wird durch DBSWIN oder dem Trigger PRESENTATIONSTATE_AU0 gesetzt.
ALTER TABLE GRUPPE ADD PREVIEWINVALID CHAR(1) DEFAULT '0' NOT NULL;

-- Foreign Key Constraint von XRAYVIDEO.PNR zu PATIENT.PNR. 
-- XRAYVIDEO.PNR darf nicht NULL sein.
-- Lsche alle Zeilen aus XRAYVIDEO, die 
-- (a) eine ungltige VORGNR (=NULL) enthalten, oder
-- (b) eine ungltige PNR enthalten (entweder NULL oder ein Wert, der in Tabelle PATIENT nicht existiert).
-- Die referenzierten Bilder knnen ber den DB-Reconstruct Mechanismus wieder importiert werden.
DELETE FROM XRAYVIDEO xv
WHERE xv.VORGNR IS NULL           
OR xv.PNR IS NULL
OR NOT EXISTS (SELECT 1 FROM PATIENT p WHERE p.PNR = xv.PNR);

COMMIT;

UPDATE RDB$RELATION_FIELDS SET RDB$NULL_FLAG = 1 WHERE RDB$FIELD_NAME = 'PNR' AND RDB$RELATION_NAME = 'XRAYVIDEO';
ALTER TABLE XRAYVIDEO ADD CONSTRAINT FK_XRAYVIDEO_PATIENT FOREIGN KEY (PNR) REFERENCES PATIENT (PNR) ON UPDATE CASCADE ON DELETE CASCADE;

-- Foreign Key Constraint von PATHISTORY.PNR zu PATIENT.PNR.
DELETE FROM PATHISTORY ph;

COMMIT; 

ALTER TABLE PATHISTORY DROP PNR;
ALTER TABLE PATHISTORY ADD PNR VARCHAR(32) CHARACTER SET UTF8 NOT NULL;
ALTER TABLE PATHISTORY ADD CONSTRAINT PK_PATHISTORY PRIMARY KEY (PNR);
ALTER TABLE PATHISTORY ADD CONSTRAINT FK_PATHISTORY_PATIENT FOREIGN KEY (PNR) REFERENCES PATIENT (PNR) ON UPDATE CASCADE ON DELETE CASCADE;

-- Neue CHECK Constraints.
ALTER TABLE XRAYVIDEO ADD CONSTRAINT CHK_XRAYVIDEO_ITYP CHECK (ITYP IN (0,1));
ALTER TABLE PRESENTATIONSTATE ADD CONSTRAINT CHK_PRESENTATIONSTATE_ITYP CHECK (ITYP IN (0,1));
ALTER TABLE DCMIMG ADD CONSTRAINT CHK_DCMIMG_IMAGEKIND CHECK (IMAGEKIND IN (0,1));
ALTER TABLE GRUPPE ADD CONSTRAINT CHK_GRUPPE_PREVIEWINVALID CHECK (PREVIEWINVALID IN ('0', '1'));

-- Feld PATIENT.KNR auf 64 Zeichen vergrern, da die Patient ID in DICOM bis zu 64 Zeichen lang sein kann.
-- Trigger PATIENT_BI0 muss hierfr temporr gelscht werden, da er auf KNR verweist und das ALTER TABLE
-- scheitern wrde.
DROP TRIGGER PATIENT_BI0;

ALTER TABLE PATIENT ALTER KNR TYPE VARCHAR(64) CHARACTER SET UTF8;

SET TERM ^ ;

CREATE TRIGGER PATIENT_BI0 FOR PATIENT
ACTIVE BEFORE INSERT OR UPDATE POSITION 0
AS
begin
  if ((New.knr = '') OR (New.knr is null))  then
    New.knr = '**' || New.PNr;
  New.anlegedatum = CURRENT_TIMESTAMP;
  if (char_length(NEW.opendentaid)= 0) then NEW.opendentaid = NEW.pnr;
  if (char_length(NEW.systemid)= 0) then NEW.systemid = 'DBSWIN';
end
^

SET TERM ; ^

-- Trigger.
SET TERM ^ ;

CREATE TRIGGER PRESENTATIONSTATE_AU0 FOR PRESENTATIONSTATE ACTIVE
AFTER UPDATE OR DELETE POSITION 0 AS
BEGIN
   UPDATE GRUPPE g SET g.PREVIEWINVALID = '1' WHERE g.GID = old.GID;
END^

SET TERM ; ^


COMMIT;

