SET SQL DIALECT 3;

SET NAMES NONE;

/******************************************************************************/
/****                              Generators                              ****/
/******************************************************************************/

CREATE GENERATOR GEN_MEDIATAB_ID;


/******************************************************************************/
/****                                Tables                                ****/
/******************************************************************************/

CREATE TABLE ARCHIVED (
    ARCHNR      INTEGER NOT NULL,
    PRACTICEID  VARCHAR(20) NOT NULL,
    VORGNR      INTEGER,
    BART        VARCHAR(1),
    MEDIAID     VARCHAR(25),
    MEDIENTYP   INTEGER,
    SETNR       INTEGER
);

CREATE TABLE MEDIATAB (
    FREIMB       INTEGER NOT NULL,
    ZAEHLER      INTEGER NOT NULL,
    MEDIAID      VARCHAR(25) NOT NULL,
    PRACTICEID   VARCHAR(20) NOT NULL,
    STORNIERUNG  SMALLINT,
    DEFEKT       SMALLINT,
    MEDIENTYP    VARCHAR(20),
    BELEGTMB     DOUBLE PRECISION
);

CREATE TABLE MEDIATYP (
    MTYPE       VARCHAR(8) NOT NULL,
    DRIVECLASS  VARCHAR(10) NOT NULL,
    TYPEID      SMALLINT,
    USAGE       SMALLINT,
    DRIVE       VARCHAR(1)
);

CREATE TABLE VERSIONSTATE(
  VID         INTEGER NOT NULL,
  VERSNR      DOUBLE PRECISION,
  LASTCHANGE  TIMESTAMP);

CREATE TABLE MISC (
    DATEID          INTEGER NOT NULL,
    FIRSTSTARTTIME  VARCHAR(20) CHARACTER SET UTF8,
    LASTSTARTTIME   VARCHAR(20) CHARACTER SET UTF8
);

/******************************************************************************/
/****                             Primary Keys                             ****/
/******************************************************************************/

ALTER TABLE ARCHIVED ADD CONSTRAINT PK_ARCHIVED PRIMARY KEY (ARCHNR, PRACTICEID);
ALTER TABLE MEDIATAB ADD CONSTRAINT PK_MEDIATAB PRIMARY KEY (FREIMB, ZAEHLER, MEDIAID, PRACTICEID);
ALTER TABLE MEDIATYP ADD CONSTRAINT PK_MEDIATYP PRIMARY KEY (MTYPE, DRIVECLASS);
ALTER TABLE MISC ADD CONSTRAINT PK_MISC PRIMARY KEY (DATEID);
ALTER TABLE VERSIONSTATE ADD CONSTRAINT PK_VERSIONSTATE PRIMARY KEY (VID);


/******************************************************************************/
/****                               Indices                                ****/
/******************************************************************************/

CREATE INDEX ARCHIVIERUNGSNUMMER ON ARCHIVED (ARCHNR);
CREATE INDEX MEDIENID_INDEX ON ARCHIVED (MEDIAID);
CREATE INDEX VORGANG ON ARCHIVED (VORGNR);
CREATE INDEX FREIEMBYTES ON MEDIATAB (FREIMB);
CREATE INDEX MEDIENIDFREIMB ON MEDIATAB (MEDIAID, FREIMB);
CREATE INDEX MEDIENID_INDEX2 ON MEDIATAB (MEDIAID);
CREATE INDEX PRAXIS ON MEDIATAB (PRACTICEID);


/******************************************************************************/
/****                               Triggers                               ****/
/******************************************************************************/

SET TERM ^ ;


/******************************************************************************/
/****                         Triggers for tables                          ****/
/******************************************************************************/

CREATE TRIGGER MEDIATAB_BI0 FOR MEDIATAB
ACTIVE BEFORE INSERT POSITION 0
AS
BEGIN
  NEW.ZAEHLER = GEN_ID(GEN_MEDIATAB_ID, 1);
END
^

SET TERM ; ^


/******************************************************************************/
/****                              Default value                           ****/
/**** Was moved to bottom and RESTORE was added                            ****/
/****above it resulted in error during installation                        ****/
/**** when creating new DB:"lock conflict on no wait transaction,          ****/
/**** unsuccessful metadata update,object MISC in use                      ****/
/******************************************************************************/
RECONNECT;
INSERT INTO MISC (DATEID)
    VALUES('0');
